/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import GameState.GameOverState;
import GameState.GameState;
import GameState.HelpState;
import GameState.Level1State;
import GameState.Level2State;
import GameState.MenuState;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class GameStateManager {
    private ArrayList<GameState> gameStates = new ArrayList();
    private int currentState = 0;
    public int totalScore;
    public static final int MENUSTATE = 0;
    public static final int LEVEL1STATE = 1;
    public static final int GAMEOVERSTATE = 2;
    public static final int HELPSTATE = 3;
    public static final int LEVEL2STATE = 4;

    public int getTotal() {
        return this.totalScore;
    }

    public void setTotal(int i) {
        this.totalScore = i;
    }

    public GameStateManager() {
        this.gameStates.add(new MenuState(this));
        this.gameStates.add(new Level1State(this));
        this.gameStates.add(new GameOverState(this));
        this.gameStates.add(new HelpState(this));
        this.gameStates.add(new Level2State(this));
    }

    public void setState(int state) {
        this.currentState = state;
        this.gameStates.get(this.currentState).init();
    }

    public void update() {
        this.gameStates.get(this.currentState).update();
    }

    public void draw(Graphics2D graphics) {
        this.gameStates.get(this.currentState).draw(graphics);
    }

    public void keyPressed(int k) {
        this.gameStates.get(this.currentState).keyPressed(k);
    }

    public void keyReleased(int k) {
        this.gameStates.get(this.currentState).keyReleased(k);
    }
}

